
 ##############################################################################
 #
 # File:         e1430/clib/lib1430.mak 
 # RCS:		"@(#)$Revision: 1.3 $ $Date: 94/03/15 17:04:19 $ "
 # Description:  Nmake makefile for LIB1430.LIB, MS-DOS environment
 # Author:       Chris Sutton
 # Created:      
 # Language:     Nmake
 # Package:      
 #
 # (C) Copyright 1994, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # This makefile builds LIB1430.LIB using Microsoft C/C++ compiler.
 #
 # When using the library, it must be linked with your program.   
 #
 # This version of the library uses SICL (Standard Instrument Control
 # Library) for RadiSys hardware access, so the link must also 
 # include the SICL library, MSSICL.LIB, and a low level 
 # library, EPCMSC.LIB.  These libraries are provided by RadiSys.
 #
 # Important Pre-processor defines:
 #   RADISYS define is for RadiSys environment such as EPC-7
 #   EMULATE_SICL define is for environments that do not have SICL  
 #                        see sicl_e.c and sicl_e.h
 #
 # These pre-processor defines are in the library source code but do not 
 # apply to DOS environments:
 #   HPUX_SOURCE define is for V382 HPUX environment
 #   E1485_SOURCE define is for E1485 SPOS environment
 #   HPVXI_CSCPI define is for V382 compiled SCPI environment
 #   HPVXI_DOWNLOAD define is for E1406 Command Module SCPI environment
 #  
 # Source is not provided for e1430_get_resamepl_data() and 
 # e1430_get_filter_data() functions in file resamp.c
 #
 ##############################################################################


# Set library revision here
REV = A.03.00X

# Location of the include files for the RadiSys SICL libraray:
SICL_INCLUDE = \EPCONNECT\INCLUDE

# compiler and library manager:
CC  = cl
LIB = lib 

# compiler flags:  AL for large memory model, W3 is warnings Za is ANSI C,
#   /D defines preprocessor directives.
CFLAGS  = /AL /W3 /Za /I$(SICL_INCLUDE) /DRADISYS /DEMULATE_SICL


OBJS=	analog.obj auto.obj data.obj display.obj error.obj intr.obj\
	io.obj filter.obj getdata.obj machine.obj meas.obj misc.obj\
	modgroup.obj saverec.obj selftest.obj table.obj testdata.obj\
	testintr.obj testmeas.obj testmem.obj testreg.obj testtrig.obj\
	timing.obj trigger.obj zoom.obj sicl_e.obj


all:	lib1430.lib 


lib1430.lib:	$(OBJS)
	del build.c
	echo const char rev[] = "$(REV)"; >build.c
	echo const char _e1430BuildId1[] = "@(#)E1430A C-Library for DOS Rev: $(REV)"; >>build.c ; 
	echo const char _e1430BuildId2[] = "@(#)LIB1430.LIB built:__DATE__ "; >>build.c
	$(CC) /c $(CFLAGS) build.c
	del lib1430.lib
	$(LIB) @<<libs.cmd
lib1430.lib &
+$(OBJS: = &^
+);
<<KEEP
	$(LIB) lib1430.lib +build.obj;


.c.obj :
	$(CC) /c $(CFLAGS) $*.c



